package gov.va.genisis2.service;

import java.util.List;

import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.CommentType;
import gov.va.genisis2.model.DataType;
import gov.va.genisis2.model.FieldToolTipDescription;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;


public interface ILookUpService {
	public int getStatusId(String statusDescription) throws GenisisServiceException;

	public RequestType getRequestType(int id) throws GenisisServiceException;

	public Source getSource(int id) throws GenisisServiceException;

	public List<Source> getDataSources() throws GenisisServiceException;

	public List<RequestType> getRequestTypes() throws GenisisServiceException;
	
	public CommentType getCommentType(int id) throws GenisisServiceException;
	
	public List<DataType> getDataTypes() throws GenisisServiceException;
	
	public DataType getDataType(int id) throws GenisisServiceException;
	  
	public List<StudyApproval> getStudyApprovalsByRole(int id) throws GenisisServiceException;
	
	public FieldToolTipDescription getTooltipDescription(String fieldName) throws GenisisServiceException;

	
	
}
